
# Tested in blender 2.79b, 2.83LTS, 2.9, 2.93.1

# Warning:
#  Sync version in nrtools.getNrOutputDir()


import bpy
import os
import sys
import importlib
from bpy.props import *

# Add addon dir to system modules directory
sys.path.append(os.path.dirname(__file__))


# addon description
bl_info = {
    "name": "Import Ninja Ripper 2",
    "author": "Rustem Fasikhov (blackninja)",
    "version": (1, 0, 7),
    "blender": (2, 99, 0),
    "location": "File > Import > Ninja Ripper 2",
    "description": "Imports Ninja Ripper 2 meshs",
    "warning": '',
    "category": "Import-Export",
}


######################################
# Blender versions workaround
######################################
def ver_register():
    if bpy.app.version < (2, 80, 0):
        return 0
    return 1

def ver_menu():
    if bpy.app.version < (2, 80, 0):
        return 0
    return 1
    

#---------------------------------------------#
if "gui0" in locals():
    if 0 == ver_menu():
        importlib.reload(gui0)
            
if "gui1" in locals():
    if 1 == ver_menu():
        importlib.reload(gui1)


######################################################################
# Force load modules Exception: register_module()  defines no classes
######################################################################
if 0 == ver_menu():
    from . import gui0 as gui
elif 1 == ver_menu():
    from . import gui1 as gui

    
def menu_func(self, context):
    self.layout.operator(gui.IMPORT_MESH_OT_nr.bl_idname, text = "Ninja Ripper 2 World Space")

def menu_func_prevs(self, context):
    self.layout.operator(gui.IMPORT_MESH_OT_nr_prevs.bl_idname, text = "Ninja Ripper 2 Local Space (T-pose)")



def register():
    if 0 == ver_register():
        # blender < 2.8
        bpy.utils.register_module(__name__)
        bpy.types.INFO_MT_file_import.append(menu_func)
        bpy.types.INFO_MT_file_import.append(menu_func_prevs)
    else:
        # blender >= 2.8
        bpy.utils.register_class(gui.IMPORT_MESH_OT_nr)
        bpy.utils.register_class(gui.IMPORT_MESH_OT_nr_prevs)
        bpy.types.TOPBAR_MT_file_import.append(menu_func)
        bpy.types.TOPBAR_MT_file_import.append(menu_func_prevs)


def unregister():
    if 0 == ver_register():
        # blender < 2.8
        bpy.types.INFO_MT_file_import.remove(menu_func)
        bpy.types.INFO_MT_file_import.remove(menu_func_prevs)
        bpy.utils.unregister_module(__name__)
    else:
        # blender >= 2.8
        bpy.types.TOPBAR_MT_file_import.remove(menu_func)
        bpy.types.TOPBAR_MT_file_import.remove(menu_func_prevs)
        bpy.utils.unregister_class(gui.IMPORT_MESH_OT_nr)
        bpy.utils.unregister_class(gui.IMPORT_MESH_OT_nr_prevs)


if __name__ == "__main__":
    register()
