import bpy
import os
import sys
from bpy.props import *


from bpy_extras.io_utils import (
        ImportHelper,
        )

from bpy.types import (
        Operator,
        OperatorFileListElement,
        )

import nrblendimp
import nrfile
import nrtools


class BaseGui:
    def draw(self, context):
        layout = self.layout
        
        # Geometry reconstruction (reverse projection)
        box = layout.box()
        #row = box.row()
        #row.label(text="Geometry reconstruction")
        row = box.row()
        row.prop(self, "projTab")
        if self.projTab == 'PROJMAT':
            row = box.row()
            row.prop(self, "exactProjMat")
            row = box.row()
            row.prop(self, "transposeProjMat")
        elif self.projTab == 'MANUAL':
            row = box.row()
            row.prop(self, "fov")
            box.separator()
            row = box.row()
            row.prop(self, "scrWidth")
            row = box.row()
            row.prop(self, "scrHeight")
            box.separator()
            row = box.row()
            row.prop(self, "nearDist")
            row = box.row()
            row.prop(self, "farDist")

        layout.separator()

        # Texturing Parameters
        box = layout.box()
        row = box.row()
        row.prop(self, "texturingTab")
        if (self.texturingTab == 'TEXCOORDBYNAME') or (self.texturingTab == 'EXTRA_TEXCOORDBYNAME'):
            row = box.row()
            row.prop(self, "texCoordAttribName")
            row = box.row()
            row.prop(self, "texUvComponentIdx")
        elif (self.texturingTab == 'SCATTERTEXCOORD') or (self.texturingTab == 'EXTRA_SCATTERTEXCOORD'):
            row = box.row()
            row.prop(self, "texScatterU")
            row = box.row()
            row.prop(self, "texScatterV")

        layout.separator()

        # Normals
        box = layout.box()
        row = box.row()
        row.prop(self, "normalsTab")
        if self.normalsTab == 'MANUAL':
            row = box.row()
            row.prop(self, "normalAttrCompX")
            row = box.row()
            row.prop(self, "normalAttrCompY")
            row = box.row()
            row.prop(self, "normalAttrCompZ")


        layout.separator()

        # DepthEnable/DepthWriteEnable/RGBWrite/RT/BackBuffer/...
        box = layout.box()
        row = box.row()
        row.prop(self, "ignoreDepthEnableFalse")
        row = box.row()
        row.prop(self, "ignoreDepthWriteEnableFalse")
        row = box.row()
        row.prop(self, "ignoreRGBWriteDisabled")
        row = box.row()
        row.prop(self, "ignoreIfRenderedToRenderTarget")
        row = box.row()
        row.prop(self, "ignoreIfRenderedToBackBuffer")
        row = box.row()
        row.prop(self, "ignoreIfRenderTargetWidthDoesNotMatchToBackBuffer")


    def execute(self, context):
        options = {
          "projmat": [[1, 0, 0, 0], [0, 1, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1]],
        }

        options['logger'] = nrfile.Logger()


        if self.projTab == 'PROJMAT':
            options['projmat'] = nrtools.stringToMat44(self.exactProjMat)
            if self.transposeProjMat:
                options['projmat'] = nrtools.transposeMat(options['projmat'])

            # Check that we can inverse projection matrix
            invProjMat = nrtools.matrixinvert(options['projmat'])
            if None == invProjMat:
                print("Inverse of projection matrix failed. Try get another from ripper log")
                return {'FINISHED'}


        elif self.projTab == 'MANUAL':
            scrWidth  = self.scrWidth
            scrHeight = self.scrHeight
            fov       = self.fov
            nearDist  = self.nearDist
            farDist   = self.farDist
            options['projmat'] = nrtools.perspMatFovLH(fov, scrWidth, scrHeight, nearDist, farDist)

        paths = [os.path.join(self.directory, name.name)
                 for name in self.files]

        options['texMode'] = str(self.texturingTab)

        # texMode == 'AUTO'/'TEXCOORDBYNAME'/'EXTRA_TEXCOORDBYNAME'
        options['texCoordAttribName'] = self.texCoordAttribName
        options['texUvComponentIdx']  = self.texUvComponentIdx

        # texMode == 'SCATTERTEXCOORD'/'EXTRA_SCATTERTEXCOORD'
        options['texScatterU'] = self.texScatterU
        options['texScatterV'] = self.texScatterV

        # Normals
        options['normalsTab']      = str(self.normalsTab)
        options['normalAttrCompX'] = self.normalAttrCompX
        options['normalAttrCompY'] = self.normalAttrCompY
        options['normalAttrCompZ'] = self.normalAttrCompZ


        options['ignoreDepthEnableFalse']         = self.ignoreDepthEnableFalse
        options['ignoreDepthWriteEnableFalse']    = self.ignoreDepthWriteEnableFalse
        options['ignoreRGBWriteDisabled']         = self.ignoreRGBWriteDisabled
        options['ignoreIfRenderedToRenderTarget'] = self.ignoreIfRenderedToRenderTarget
        options['ignoreIfRenderedToBackBuffer']   = self.ignoreIfRenderedToBackBuffer
        options['ignoreIfRenderTargetWidthDoesNotMatchToBackBuffer'] = self.ignoreIfRenderTargetWidthDoesNotMatchToBackBuffer

        # Dump options for debugging
        print(options);

        nrblendimp.importNrFiles(paths, options)

        return {'FINISHED'}



def update_funcPostVs(self, context):
    # Comp id = [0..3]
    if self.texScatterU[1] > 3:
        self.texScatterU[1] = 3
    if self.texScatterV[1] > 3:
        self.texScatterV[1] = 3
    if self.normalAttrCompX[1] > 3:
        self.normalAttrCompX[1] = 3
    if self.normalAttrCompY[1] > 3:
        self.normalAttrCompY[1] = 3
    if self.normalAttrCompZ[1] > 3:
        self.normalAttrCompZ[1] = 3

#######################################################################################################
#######################################################################################################
#######################################################################################################
def update_funcPreVs(self, context):
    # Comp id = [0..3]
    if self.posX[1] > 3:
        self.posX[1] = 3
    if self.posY[1] > 3:
        self.posY[1] = 3
    if self.posZ[1] > 3:
        self.posZ[1] = 3
    if self.texScatterU[1] > 3:
        self.texScatterU[1] = 3
    if self.texScatterV[1] > 3:
        self.texScatterV[1] = 3

class BaseGuiPreVs:
    def draw(self, context):
        layout = self.layout
        
        box = layout.box()
        row = box.row()
        row.prop(self, "vertexLayoutTab")
        if self.vertexLayoutTab == 'MANUAL':
            row = box.row()
            row.prop(self, "posX")
            row = box.row()
            row.prop(self, "posY")
            row = box.row()
            row.prop(self, "posZ")
            box.separator()

            #layout.separator()

            box = layout.box()
            row = box.row()
            row.prop(self, "texturingTab")
            if (self.texturingTab == 'SCATTERTEXCOORD') or (self.texturingTab == 'EXTRA_SCATTERTEXCOORD'):
                row = box.row()
                row.prop(self, "texScatterU")
                row = box.row()
                row.prop(self, "texScatterV")
            elif (self.texturingTab == 'TEXCOORDBYNAME') or (self.texturingTab == 'EXTRA_TEXCOORDBYNAME'):
                row = box.row()
                row.prop(self, "texCoordAttribName")
                row = box.row()
                row.prop(self, "texUvComponentIdx")


            #layout.separator()

            box = layout.box()
            row = box.row()
            row.prop(self, "normalsTab")
            if self.normalsTab == 'MANUAL':
                row = box.row()
                row.prop(self, "normalAttrCompX")
                row = box.row()
                row.prop(self, "normalAttrCompY")
                row = box.row()
                row.prop(self, "normalAttrCompZ")

    def execute(self, context):
        options = {}
        options['logger'] = nrfile.Logger()

        paths = [os.path.join(self.directory, name.name)
                 for name in self.files]

        options['vertexLayoutTab'] = str(self.vertexLayoutTab)
        options['texMode'] = str(self.texturingTab)

        # texMode == 'AUTO'/'TEXCOORDBYNAME'/'EXTRA_TEXCOORDBYNAME'
        options['texCoordAttribName'] = self.texCoordAttribName
        options['texUvComponentIdx']  = self.texUvComponentIdx

        # texMode == 'SCATTERTEXCOORD'/'EXTRA_SCATTERTEXCOORD'
        options['texScatterU'] = self.texScatterU
        options['texScatterV'] = self.texScatterV


        options['posX'] = self.posX
        options['posY'] = self.posY
        options['posZ'] = self.posZ


        # Normals
        options['normalsTab']      = str(self.normalsTab)
        options['normalAttrCompX'] = self.normalAttrCompX
        options['normalAttrCompY'] = self.normalAttrCompY
        options['normalAttrCompZ'] = self.normalAttrCompZ


        # Dump options for debugging
        print(options);

        nrblendimp.importNrFilesPreVs(paths, options)

        return {'FINISHED'}
